<?php
/**
 * Plugin Name: Leaf – Clean Lightbox
 * Description: Lightweight lightbox plugin using vanilla JS. No jQuery, no inline scripts. CSP and XSS safe.
 * Version: 1.1.2
 * Author: wpsecurityjp
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Text Domain: leaf-clean-lightbox
 */

namespace WPSecurityJP\CleanLightbox;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access
}

/**
 * ─── Constants ───
 * Prefix: CLIGHT_
 */
define( 'CLIGHT_VERSION', '1.1.0' );
define( 'CLIGHT_PLUGIN_FILE', __FILE__ );
define( 'CLIGHT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CLIGHT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );


/**
 * Enqueue assets
 */
add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\\clight_enqueue_assets' );
function clight_enqueue_assets() : void {
	if ( is_admin() ) {
		return;
	}

	$css_path = CLIGHT_PLUGIN_DIR . 'assets/lightbox.css';
	$js_path  = CLIGHT_PLUGIN_DIR . 'assets/lightbox.js';

	$css_ver = file_exists( $css_path ) ? (string) filemtime( $css_path ) : CLIGHT_VERSION;
	$js_ver  = file_exists( $js_path )  ? (string) filemtime( $js_path )  : CLIGHT_VERSION;

	wp_enqueue_style(
		'clight-lightbox',
		CLIGHT_PLUGIN_URL . 'assets/lightbox.css',
		[],
		$css_ver
	);

	wp_enqueue_script(
		'clight-lightbox',
		CLIGHT_PLUGIN_URL . 'assets/lightbox.js',
		[],
		$js_ver,
		true // footer
	);
}
